% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NumSingleton.R
\name{NumSingleton}
\alias{NumSingleton}
\title{Decoding of \code{singletonMethod}}
\usage{
NumSingleton(singletonMethod)
}
\arguments{
\item{singletonMethod}{String to be decoded. If necessary, the input string is extended with \code{F}'s.}
}
\value{
A character vector or \code{NULL}
}
\description{
A \code{\link{GaussSuppression}} \code{singletonMethod} starting with \code{"num"} is decoded into separate characters.
Part of the theory for interpreting the 3rd, 4th, and 5th characters is discussed in Langsrud (2024).
To utilize possibly duplicated contributor IDs, the 2nd character must be \code{"T"}.
}
\details{
Any \code{F} means the feature is turned off.
Other characters have the following meaning:
\enumerate{
\item \code{singleton2Primary} (1st character):
\itemize{
\item \code{T}: All singletons are forced to be primary suppressed.
\item \code{t}: Non-published singletons are primary suppressed.
}
\item \code{integerUnique} (2nd character):
\itemize{
\item \code{T}: Integer values representing the unique contributors are utilized.  Error if \code{singleton} not supplied as integer.
\item \code{t}: As \code{T} above, but instead of error, the feature is turned off  (as \code{F}) if \code{singleton} is not supplied as integer.
}
\item \code{sum2} (3rd character):
\itemize{
\item \code{T}: Virtual primary suppressed cells are made,
which are the sum of some suppressed inner cells and which can be divided into two components.
At least one component is singleton contributor. The other component may be an inner cell.
\item \code{H}: As \code{T} above. And in addition, the other component can be any primary suppressed published cell.
This method may be computationally demanding for big data.
}
\item \code{elimination} (4th character):
\itemize{
\item \code{t}: The singleton problem will be handled by methodology implemented as a part of the Gaussian elimination algorithm.
\item \code{m}: As \code{t} above. And in addition, a message will be printed to inform about problematic singletons.
Actual reveals will be calculated when \code{singleton2Primary = T} (1st character)
and when \code{singleton2Primary = t} yield the same result as \code{singleton2Primary = T}.
Problematic singletons can appear since the algorithm is not perfect in the sense that the elimination of rows may cause problems.
Such problems can be a reason not to switch off \code{sum2}.
\item \code{w}: As \code{m} above, but \code{warning} instead of \code{message}.
\item \code{T}, \code{M} and \code{W}: As \code{t}, \code{m} and \code{w} above.
In addition, the gauss elimination routine is allowed to run in parallel with different sortings
so that the problem of eliminated singleton rows is reduced.
\item \code{f}: As \code{F}, which means that the elimination feature is turned off.
However, when possible, a message will provide information about actual reveals, similar to \code{m} above.
}
\item \code{combinations} (5th character):
\itemize{
\item \code{T}: This is a sort of extension of \code{singleton2Primary} which is relevant when both \code{integerUnique} and \code{elimination} are used.
For each unique singleton contributor, the method seeks to protect all linear combinations of singleton cells from the unique contributor.
Instead of construction new primary cells, protection is achieved as a part of the elimination procedure.
Technically this is implemented by extending the above \code{elimination} method.
It cannot be guaranteed that all problems are solved, and this is a reason not to turn off \code{singleton2Primary}.
Best performance is achieved when \code{elimination} is \code{T}, \code{M} or \code{W}.
\item \code{t}:  As \code{T}, but without the added singleton protection.
This means that protected linear combinations cannot be calculated linearly from non-suppressed cells.
However, other contributors may still be able to recalculate these combinations using their own suppressed values.
}
}
}
\examples{
NumSingleton("numTFF")
NumSingleton("numFtT")
NumSingleton("numttH")
NumSingleton("numTTFTT")
}
\references{
Langsrud, Ø. (2024):
\dQuote{Secondary Cell Suppression by Gaussian Elimination: An Algorithm Suitable for Handling Issues with Zeros and Singletons}.
Presented at: \emph{Privacy in statistical databases}, Antibes, France. September 25-27, 2024.
\doi{10.1007/978-3-031-69651-0_6}
}
