% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSL.R
\name{sslRegress}
\alias{sslRegress}
\title{Regression on graphs}
\usage{
sslRegress(xl, yl, xu, graph.type = "exp", dist.type = "Euclidean", alpha,
  alpha1, alpha2, p = 2, method = "Tikhonov", gamma = 1)
}
\arguments{
\item{xl}{a n * p matrix or data.frame of labeled data.}

\item{yl}{a n * 1 binary labels(1 or -1).}

\item{xu}{a m * p matrix or data.frame of unlabeled data.}

\item{graph.type}{character string; which type of graph should be created? Options
include\code{tanh} and \code{exp}.
\itemize{\item \code{tanh}:tanh-weighted graphs.  \code{w(i,j) = (tanh(alpha1(d(i,j) - alpha2)) + 1)/2}.where \code{d(i,j)} denotes the distance between point i and j. Hyperparameters \code{alpha1} and \code{alpha2} control the slope and cutoff value respectively.
\item \code{exp} :exp-weighted graphs.\code{w(i,j) = exp(-d(i,j)^2/alpha^2)},where \code{d(i,j)} denotes the distance between point i and j. Hyperparameter \code{alpha} controls the decay rate.}}

\item{dist.type}{character string; this parameter controls the type of distance measurement.(see \code{\link{dist}} or \code{\link{pr_DB}}).}

\item{alpha}{numeric parameter needed when \code{graph.type = exp}}

\item{alpha1}{numeric parameter needed when \code{graph.type = tanh}}

\item{alpha2}{numeric parameter needed when \code{graph.type = tanh}}

\item{p}{an ineger parameter controls the power of Laplacian for regularization.}

\item{method}{character string; this parameter choose two possible algorithms:"Tikhonov" means  Tikhonov regularization;"Interpolated" means Interpolated regularization.}

\item{gamma}{a  parameter of Tikhonov regularization.}
}
\value{
a m * 1 integer vector representing the predicted labels  of  unlabeled data(1 or -1).
}
\description{
\code{sslRegress} develops a regularization framework on graphs.It supports many
kinds of distance measurements and graph representations. However, it only supports binary classifications.
}
\examples{
data(iris)
xl<-iris[c(1:20,51:70),-5]
xu<-iris[c(21:50,71:100),-5]
yl<-rep(c(1,-1),each=20)
# Tikhonov regularization
yu1<-sslRegress(xl,yl,xu,graph.type="tanh",alpha1=-2,alpha2=1)
yu2<-sslRegress(xl,yl,xu,graph.type="exp",alpha = 1)
# Interpolated regularization
yu3<-sslRegress(xl,yl,xu,graph.type="tanh",alpha1=-2,alpha2=1,method="Interpolated")
yu4<-sslRegress(xl,yl,xu,graph.type="exp",alpha = 1,method="Interpolated")
}
\author{
Junxiang Wang
}
\references{
Belkin, M., Matveeva, I., & Niyogi, P. (2004a). Regularization and semisupervised learning on large graphs. COLT
}
\seealso{
\code{\link{pr_DB}} \code{\link{dist}}
}

