% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMNearestMeanClassifier.R
\name{EMNearestMeanClassifierSSLR}
\alias{EMNearestMeanClassifierSSLR}
\title{General Interface for EMNearestMeanClassifier model}
\usage{
EMNearestMeanClassifierSSLR(method = "EM", scale = FALSE, eps = 1e-04)
}
\arguments{
\item{method}{character; Currently only "EM"}

\item{scale}{Should the features be normalized? (default: FALSE)}

\item{eps}{Stopping criterion for the maximinimization}
}
\description{
model from RSSL package
Semi-Supervised Nearest Mean Classifier using Expectation Maximization

Expectation Maximization applied to the nearest mean classifier assuming Gaussian classes with a spherical covariance matrix.

Starting from the supervised solution, uses the Expectation Maximization algorithm (see Dempster et al. (1977)) to iteratively update the means and shared covariance of the classes (Maximization step) and updates the responsibilities for the unlabeled objects (Expectation step).
}
\examples{
library(tidyverse)
library(tidymodels)
library(caret)
library(SSLR)

data(breast)

set.seed(1)
train.index <- createDataPartition(breast$Class, p = .7, list = FALSE)
train <- breast[ train.index,]
test  <- breast[-train.index,]

cls <- which(colnames(breast) == "Class")

#\% LABELED
labeled.index <- createDataPartition(breast$Class, p = .2, list = FALSE)
train[-labeled.index,cls] <- NA


m <- EMNearestMeanClassifierSSLR() \%>\% fit(Class ~ ., data = train)

#Accesing model from RSSL
model <- m$model

#Accuracy
predict(m,test) \%>\%
  bind_cols(test) \%>\%
  metrics(truth = "Class", estimate = .pred_class)
}
\references{
Dempster, A., Laird, N. & Rubin, D., 1977. Maximum likelihood from incomplete data via the EM algorithm. Journal of the Royal Statistical Society. Series B, 39(1), pp.1-38.
}
