% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.SSN2}
\alias{residuals.SSN2}
\alias{residuals.ssn_lm}
\alias{resid.ssn_lm}
\alias{rstandard.ssn_lm}
\alias{residuals.ssn_glm}
\alias{resid.ssn_glm}
\alias{rstandard.ssn_glm}
\title{Extract fitted model residuals}
\usage{
\method{residuals}{ssn_lm}(object, type = "response", ...)

\method{resid}{ssn_lm}(object, type = "response", ...)

\method{rstandard}{ssn_lm}(model, ...)

\method{residuals}{ssn_glm}(object, type = "deviance", ...)

\method{resid}{ssn_glm}(object, type = "deviance", ...)

\method{rstandard}{ssn_glm}(model, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{type}{\code{"response"} for response residuals, \code{"pearson"}
for Pearson residuals, or \code{"standardized"} for standardized residuals.
For \code{ssn_lm()} fitted model objects, the default is \code{"response"}.
For \code{ssn_glm()} fitted model objects, deviance residuals are also
available (\code{"deviance"}) and are the default residual type.}

\item{...}{Other arguments. Not used (needed for generic consistency).}

\item{model}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}
}
\value{
The residuals as a numeric vector.
}
\description{
Extract residuals from a fitted model object.
\code{resid} is an alias.
}
\details{
The response residuals are taken as the response minus the fitted values
for the response: \eqn{y - X \hat{\beta}}. The Pearson residuals are the
response residuals pre-multiplied by their inverse square root.
The standardized residuals are Pearson residuals divided by the square
root of one minus the leverage (hat) value. The standardized residuals are often used to
check model assumptions, as they have mean zero and variance approximately one.

\code{rstandard()} is an alias for \code{residuals(model, type = "standardized")}.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
residuals(ssn_mod)
resid(ssn_mod)
rstandard(ssn_mod)
}
