% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hinge.R
\name{getHinge}
\alias{getHinge}
\alias{print.hinge}
\title{Hinge error function of SVM-Maj}
\usage{
getHinge(hinge = "quadratic", delta = 3, eps = 1e-08)
}
\arguments{
\item{hinge}{Hinge error function to be used, possible values are 
\code{'absolute'}, \code{'quadratic'} and \code{'huber'}}

\item{delta}{The parameter of the huber hinge 
(only if \code{hinge = 'huber'}).}

\item{eps}{Specifies the maximum steepness of the quadratic majorization 
function \code{m(q) = a * q ^ 2 -2 * b * q + c}, where 
\code{a <= .25 * eps ^ -1}.}
}
\value{
The hinge error function with arguments \code{q} and \code{y} to 
  compute the hinge error. The function returns a list with the parameters 
  of the majorization function SVM-Maj (\code{a}, \code{b} and \code{c}) 
  and the loss error of each object (\code{loss}).
}
\description{
This function creates a function to compute the hinge error, 
given its predicted value \code{q} and its class \code{y}, 
according to the loss term of the Support Vector machine loss function.
}
\examples{
hingefunction <- getHinge()
## plot hinge function value and, if specified, 
## the majorization function at z
## plot(hingefunction, z = 3)
## generate loss function value
loss  <- hingefunction(q = -10:10, y = 1)$loss
print(loss)
plot(hingefunction, z = 3)
}
\references{
P.J.F. Groenen, G. Nalbantov and J.C. Bioch (2008) 
   \emph{SVM-Maj: a majorization approach to linear support
   vector machines with different hinge errors.}
}
\seealso{
\code{\link{svmmaj}}
}
