% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_sampling_stations.R
\name{update_sampling_stations}
\alias{update_sampling_stations}
\title{Update reserve sampling stations}
\usage{
update_sampling_stations(
  file_path = "inst/extdata",
  file_name = "sampling_stations.csv"
)
}
\arguments{
\item{file_path}{path to directory with new file}

\item{file_name}{name of new csv file}
}
\value{
Returns TRUE on a successful run, FALSE on a failure.
}
\description{
Script to modify the internal sampling_sites.rda file for adding new reserves or for making changes to existing sampling station locations.
}
\details{
This is a standalone function used to replace the internal SWMPrExtension sampling sites data table used by the get_sites.R function. It reads a csv-formatted file of all NERRS SWMP stations that the user has downloaded from the CDMO SWMP station website: \url{https://cdmo.baruch.sc.edu/data/swmp-stations/}.

This downloaded csv-formatted file and its location are the only input arguments to \code{update_sampling_station()}. The current station information is loaded from \code{data/sampling_stations.rda}, a copy of which is written out as \code{data/sampling_stations_backup.rda}, and the new data file is read, formatted appropriately, and written out as \code{data/sampling_stations.rda}.

Note: This function need only be run when new reserves are added, stations are moved, etc.
}
\examples{
# Provide a bad file name to get error message
x <- update_sampling_stations("data","bad_file_name.csv")
print(x)


# Commented out example with a valid, but older, filename.
# WARNING! Don't actually run this example unless you have a
# more recent csv file that can be used to update the rda file.
# x <- update_sampling_stations("inst/extdata","NERRS_sampling_stations.csv")
# print(x)

}
\author{
Dave Eslinger
}
\concept{data maintenance}
