% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssc_meancomp.R
\name{ssc_meancomp}
\alias{ssc_meancomp}
\title{Sample Size Calculation for the Comparison of Means in Phase III Clinical Trials}
\usage{
ssc_meancomp(design, ratio, alpha, power, sd, theta, delta)
}
\arguments{
\item{design}{The design of the clinical trials.
\cr 1L
  \cr Testing for equality
\cr 2L
  \cr Superiority trial
\cr 3L
  \cr Non-inferiority trial
\cr 4L
  \cr Equivalence trial.}

\item{ratio}{The ratio between the number of subjects in the treatment arm and that in the control arm}

\item{alpha}{Type I error rate}

\item{power}{Statistical power of the test (1-type II error rate)}

\item{sd}{The standard deviation of observed outcomes in both arms}

\item{theta}{The true mean difference between two arms}

\item{delta}{The prespecified superiority, non-inferiority or equivalence margin}
}
\value{
samplesize
}
\description{
This function aims to calculate sample size for the comparison of means
in Phase III clinical trials.
}
\examples{
##The comparison of means, a non-inferiority trial and the non-inferiority margin is -0.05
ssc_meancomp(design = 3L, ratio = 1, alpha = 0.05, power = 0.8, sd = 0.1, theta = 0, delta = -0.05)

}
\references{
Chow S, Shao J, Wang H. 2008. Sample Size Calculations in Clinical Research. 2nd Ed. Chapman & Hall/CRC Biostatistics Series.

Yin, G. 2012. Clinical Trial Design: Bayesian and Frequentist Adaptive Methods. John Wiley & Sons.
}
