% Generated by roxygen2 (4.0.2): do not edit by hand
\name{perspBox}
\alias{perspBox}
\title{Create an Empty Persp Plot}
\usage{
perspBox(x1, x2, y, x1lab = "x1", x2lab = "x2", ylab = "y", x1lim, x2lim,
  ...)
}
\arguments{
\item{x1}{data for the first horizontal axis, an R vector}

\item{x2}{data for the second horizontal axis, an R vector}

\item{y}{data for the vertical axis, an R vector}

\item{x1lab}{label for the x1 axis, (the one called "xlab" inside persp)}

\item{x2lab}{label for the x2 axis, (the one called "ylab" inside persp)}

\item{ylab}{label for the y (vertical) axis (the one called "zlab" inside persp)}

\item{x1lim}{Optional: limits for x1 axis (should be a vector with 2 elements)}

\item{x2lim}{Optional: limits for x2 axis (should be a vector with 2 elements)}

\item{...}{further arguments that are passed to persp, including xlab,
ylab, zlab, xlim, ylim, and zlim are going to be ignored.}
}
\value{
The perspective matrix that is returned by persp
}
\description{
Creates an empty persp plot objtect.
}
\examples{
x1 <- 1:10
x2 <- 41:50
y <-  rnorm(10)
perspBox(x1, x2, y)
box <- perspBox(x1, x2, y, ticktype = "detailed", nticks=10)
mypoints1 <- trans3d( x1, x2, y, pmat = box )
points(mypoints1, pch = 16, col= "blue")
}

