% Generated by roxygen2 (4.0.2): do not edit by hand
\encoding{UTF-8}
\name{tsCollapse}
\alias{tsCollapse}
\title{Aggregated Data by Time Parameters}
\usage{
tsCollapse(data, by = c("day", "month", "year"), FUN, na.rm = FALSE,
  factor = NULL, civil = FALSE, plot = TRUE)
}
\arguments{
\item{data}{a \bold{timedf} object}

\item{by}{the method to break up the dependent variable; options: \code{"day"},\code{ "month"}, or \code{"year"}.}

\item{FUN}{a function to aggregate data \code{sum, mean, min, max, etc}.}

\item{na.rm}{A logical value for \code{na.rm}, default is \code{FALSE}}

\item{factor}{is the aggregator factor; a numeric value representing days, months or years to perform aggregation by.}

\item{civil}{Wether the years start from the civil date or from the first observation in data. The default is \code{civil = FALSE}.}

\item{plot}{whether the data.frame to be plotted, default is \code{plot = TRUE}.}
}
\description{
Return a \code{data.frame} with aggregated data by time parameters. In order to use this function, you have to have a \link{as.timedf} data.frame.
}
\details{
A data.frame of type long with summarized time series data (y) and time parameters formatted as POSIXct.
}
\note{
To weekly aggregation, set \code{by = "day"} and \code{factor = 7}
}
\examples{
data(us2012)
Obama.ts <- as.timedf(us2012[,3], '\%Y-\%m-\%d', us2012[,8])

# Daily aggregated means for data:
daily <- tsCollapse(Obama.ts, by = "day", mean)

# Weekly aggregated means for data:
weekly <- tsCollapse(Obama.ts, by = "day", factor = 7, mean)

# monthly aggregated means for data:
monthly <- tsCollapse(Obama.ts, by = "month", mean)

# bimonthly or semimonthly aggregated means for data:
bimonthly <- tsCollapse(Obama.ts,by = "month", mean, factor = 2)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\keyword{Data-Manipulation}

