% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/crosstable.R
\encoding{UTF-8}
\name{crosstable}
\alias{crosstable}
\alias{tab}
\title{Cross-tabulation}
\usage{
crosstable(..., deparse.level = 2)

tab(...)
}
\arguments{
\item{deparse.level}{Integer controlling the construction of labels in the case of non-matrix-like arguments. If 0, middle 2 rownames, if 1, 3 rownames, if 2, 4 rownames (default).}

\item{\dots}{The data paremeters.}
}
\value{
Well-formatted cross tabulation. Also can genarate latex syntax of cross tabulation.
}
\description{
\code{crosstable} produces all possible two-way tabulations of the variables specified.

Cross-tabulation
}
\examples{
with(titanic, crosstable( SEX, AGE))
with(titanic, tab( SEX, AGE, SURVIVED))

# Agresti (2002), table 3.11, p. 106
GSS <- data.frame(
   expand.grid(sex=c("female", "male"),
   party=c("dem", "indep", "rep")),
   count=c(279,165,73,47,225,191))

gender = rep(c("female","male"),c(1835,2691))
admitted = rep(c("yes","no","yes","no"),c(557,1278,1198,1493))
dept = rep(c("A","B","C","D","E","F","A","B","C","D","E","F"),
           c(89,17,202,131,94,24,19,8,391,244,299,317))
dept2 = rep(c("A","B","C","D","E","F","A","B","C","D","E","F"),
           c(512,353,120,138,53,22,313,207,205,279,138,351))
department = c(dept,dept2)
ucb = data.frame(gender,admitted,department)
with(ucb, tab(admitted, gender))
}
\keyword{Descriptive}
\keyword{Tables}

