% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdf_to_dt.R
\name{dt_to_netcdf}
\alias{dt_to_netcdf}
\title{Write a netcdf from a long data table}
\usage{
dt_to_netcdf(
  dt,
  nc_out,
  vars = NULL,
  units = NULL,
  dim_vars = dimvars(dt),
  dim_var_units = NULL,
  check = interactive(),
  description = NULL
)
}
\arguments{
\item{dt}{a data.table}

\item{nc_out}{File name (including path) of the netcdf to write.}

\item{vars}{names of columns in dt containing variables. If this is NULL, the function guesses and asks for confirmation.}

\item{units}{character vector containing the units for vars (in the same order). If this is NULL (default), the user is prompted for input.}

\item{dim_vars}{names of columns in dt containing dimension variables. If this is NULL, the function guesses and asks for confirmation.}

\item{dim_var_units}{character vector containing the units for dim_vars (in the same order). If this is NULL (default), the user is prompted for input (except for lon/lat).}

\item{check}{If check is TRUE, the function asks the user whether an existing file should be overwritten, and whether the correct dimvars have been guessed.}

\item{description}{For adding a global attribute 'Description' as a string.}
}
\value{
none.
}
\description{
This function writes a netcdf from a long data table, the usual data format in SeaVal.
If not specified, it guesses (based on column names) which columns contain dimension variables and which contain variables.
The function currently does not support writing netcdfs with multiple variables that have different sets of dimension variables!
}
\examples{
example_dt = data.table(lon = 1:3, month = 4:6, prec = 7:9)
file_name = tempfile()
dt_to_netcdf(dt = example_dt, nc_out = file_name,
             vars = "prec", units = "mm",
             dim_vars = c("lon","month"), dim_var_units = c("degree longitude","month"))



}
