% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_country_names}
\alias{add_country_names}
\title{Add country names to a data table with lon/lat coordinates}
\usage{
add_country_names(dt, regions = EA_country_names())
}
\arguments{
\item{dt}{the data table.}

\item{regions}{Character vector of country names for which shapefiles are loaded.
By default, countries in East Africa are loaded, see \code{\link{EA_country_names}}.
If you set regions = '.', the entire world is loaded, but this makes the function slower.}
}
\value{
The provided data table with an extra column with country names
}
\description{
Takes a data table with lon/lat coordinates and adds a column
'country' to it, containing the name of the country, the coordinate belongs to.
}
\examples{
dt = add_country_names(chirps_monthly)

}
