% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantiles.R
\name{chirps_ver_map_quantiles}
\alias{chirps_ver_map_quantiles}
\title{Calculates and saves the quantiles of CHIRPS data required for verification maps.}
\usage{
chirps_ver_map_quantiles(
  clim_period = 1991:2020,
  version = "UCSB",
  resolution = "low",
  CHIRPS_dir = chirps_dir(),
  seasons = TRUE
)
}
\arguments{
\item{clim_period}{which years should be considered for the quantiles.}

\item{version}{which version of CHIRPS, 'UCSB' or 'ICPAC'? Can be a vector with both.}

\item{resolution}{If this is set to 'high', the quantiles are also calculated for high-resolution CHIRPS data. This is not nicely implemented right now and will take a lot of memory and time.}

\item{CHIRPS_dir}{directory the CHIRPS data is stored in.}

\item{seasons}{Are we plotting for seasonal or monthly forecasts?}
}
\value{
data table with quantiles.
}
\description{
Calculates and saves the quantiles of CHIRPS data required for verification maps.
}
\examples{
\dontrun{chirps_ver_map_quantiles()}

}
