% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICPAC_temp.R
\name{get_mask}
\alias{get_mask}
\title{Function to create a mask of dry regions from CHIRPS}
\usage{
get_mask(
  season,
  clim_years = 1990:2020,
  version = "UCSB",
  resolution = "low",
  us = (resolution == "low")
)
}
\arguments{
\item{season}{For which season do you want to calculate the mask? Needs to be either 'MAM', 'JJAS' or 'OND'.}

\item{clim_years}{Numeric vector of years. Which years should be used to establish the mask?}

\item{version, resolution, us}{Passed to \code{\link{load_chirps}}. Which CHIRPS version do you want to use and on what resolution?}
}
\description{
A gridpoint is masked for a given season (either 'MAM', 'JJAS' or 'OND'), if, on average, less than 10\% of the annual total of rainfall
occur during the season. This function loads CHIRPS data, and derives this mask as a data table of lon, lat coordinates, only containing
the coordinates that shouldn't be masked. You can apply the mask to an existing data table using dt = combine(dt,mask).
}
\examples{
if(interactive()) get_mask('MAM')

}
