% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SemanticNetworkCleaner.R
\name{partboot.plot}
\alias{partboot.plot}
\title{Plot for partboot}
\usage{
partboot.plot(object, paired = FALSE, CI = 0.975, labels = NULL,
  measures = c("ASPL", "CC", "Q", "S", "MeanStrength"))
}
\arguments{
\item{object}{An object from \link[SemNetCleaner]{partboot}}

\item{paired}{Is object from a paired \link[SemNetCleaner]{partboot}?}

\item{CI}{Confidence intervals to use for plot.
Defaults to .975}

\item{labels}{Labels to be used in plot.
Defaults to NULL.
Typed responses will be requested if NULL}

\item{measures}{Measures to be plotted}
}
\value{
Returns plots for the specified measures
}
\description{
Bootstraps (without replacement) the nodes in the network and computes global network characteristics
}
\examples{
#finalize rmatA
finalCmat <- finalize(convmat)
#finalize rmatB
finalRmat <- finalize(rmat)

#equate rmatA and rmatB
eq1 <- equate(finalCmat,finalRmat)

#obtain respective equated response matrices
eqCmat <- eq1$rmatA
eqRmat <- eq1$rmatB

\donttest{
results <- partboot(eqCmat, eqRmat, corr = "cosine", cores = 4)

#labels
labs <- c("eqCmat","eqRmat")
partboot.plot(results, paired = TRUE, labels = labs)
}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
