% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qwerty.dist.R
\name{qwerty.dist}
\alias{qwerty.dist}
\title{QWERTY Distance for Same Length Words}
\usage{
qwerty.dist(wordA, wordB)
}
\arguments{
\item{wordA}{Character vector.
Word to be compared}

\item{wordB}{Character vector.
Word to be compared}
}
\value{
Numeric value for distance between \code{wordA} and \code{wordB}
}
\description{
Computes QWERTY Distance for words that have
the same number of characters. Distance is computed based on
the number of keys a character is away from another character
on a QWERTY keyboard
}
\examples{
#Identical values for Damerau-Levenshtein 
stringdist::stringdist("big", "pig", method="dl")

stringdist::stringdist("big", "bug", method="dl")

#Different distances for QWERTY
qwerty.dist("big", "pig")

qwerty.dist("big", "bug") # Probably meant to type "bug" 

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
