% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelEstimation.R
\name{enetEstimation}
\alias{enetEstimation}
\title{Elastic net estimation}
\usage{
enetEstimation(
  x,
  response,
  control = list(alpha = 0.5, s = "lambda.min", family = "gaussian", grouped = FALSE),
  ...
)
}
\arguments{
\item{x}{An object of type \code{\link[tm]{DocumentTermMatrix}}.}

\item{response}{Response variable including the given gold standard.}

\item{control}{(optional) A list of parameters defining the model as follows:
\itemize{
 \item{"alpha"}{Abstraction parameter for switching between LASSO 
 and ridge regularization (with default \code{alpha=0.5}). 
 Best option is to loop over this parameter and  test different alternatives.}
 \item{"s"}{Value of the parameter lambda at which the elastic net is evaluated. Default
is \code{s="lambda.1se"} which takes the calculated minimum value for \eqn{\lambda} 
and then subtracts one standard error in order to avoid overfitting. This often
results in a better performance than using the minimum value itself given by 
\code{lambda="lambda.min"}.}
 \item{"family"}{Distribution for response variable. Default is \code{family="gaussian"}.
For non-negative counts, use \code{family="poisson"}. For binary variables
\code{family="binomial"}. See \code{\link[glmnet]{glmnet}} for further details.}
 \item{"grouped"} {Determines whether grouped function is used (with default \code{FALSE}).}
}}

\item{...}{Additional parameters passed to function for \code{\link[glmnet]{glmnet}}.}
}
\value{
Result is a list with coefficients, coefficient names and the model intercept.
}
\description{
Function estimates coefficients based on elastic net regularization.
}
