% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.SentimentDictionaryWeighted}
\alias{predict.SentimentDictionaryWeighted}
\title{Prediction for given dictionary}
\usage{
\method{predict}{SentimentDictionaryWeighted}(
  object,
  newdata = NULL,
  language = "english",
  weighting = function(x) tm::weightTfIdf(x, normalize = FALSE),
  ...
)
}
\arguments{
\item{object}{Dictionary of class \code{\link{SentimentDictionaryWeighted}}.}

\item{newdata}{A vector of characters, a \code{data.frame}, an object of type 
\code{\link[tm]{Corpus}}, \code{\link[tm]{TermDocumentMatrix}} or
\code{\link[tm]{DocumentTermMatrix}} .}

\item{language}{Language used for preprocessing operations (default: 
English).}

\item{weighting}{Function used for weighting of words; default is a a link to the 
tf-idf scheme.}

\item{...}{Additional parameters passed to function for e.g. 
preprocessing.}
}
\value{
\code{data.frame} with predicted sentiment scores.
}
\description{
Function takes a dictionary of class \code{\link{SentimentDictionaryWeighted}} with weights 
as input. It then applies this dictionary to textual contents in order to calculate
a sentiment score.
}
\examples{
#' # Create a vector of strings
documents <- c("This is a good thing!",
               "This is a very good thing!",
               "This is okay.",
               "This is a bad thing.",
               "This is a very bad thing.")
response <- c(1, 0.5, 0, -0.5, -1)

# Generate dictionary with LASSO regularization
dictionary <- generateDictionary(documents, response)

# Compute in-sample performance
sentiment <- predict(dictionary, documents)
compareToResponse(sentiment, response)
}
\seealso{
\code{\link{SentimentDictionaryWeighted}}, \code{\link{generateDictionary}} and
\code{\link{compareToResponse}} for default dictionary generations
}
\keyword{dictionary}
\keyword{evaluation}
\keyword{sentiment}
