% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.R
\name{create_network_from_modules}
\alias{create_network_from_modules}
\title{Create a network object.}
\usage{
create_network_from_modules(p, module_list,
  node_names = as.character(1:p), ...)
}
\arguments{
\item{p}{The number of nodes in the graph}

\item{module_list}{A named list of 'network_module' objects.}

\item{node_names}{(optional) Vector of strings providing names for each node
in the graph. Default names are "1", "2", ..., "p".}

\item{...}{Additional arguments passed to random_module(); only
used if modules need to be generated.}
}
\value{
A network object.
}
\description{
Creates a graph with certain features. This network is then
used with other sample generating methods to obtain count data. Note: the
module structure is used to incorporate general pathways in the graph. These
are randomly constructed by generating a small-world graph using the Watts-Strogatz
method (implemented through igraph::watts.strogatz.game).
}
\examples{
# Networks can be crafted manually by first constructing the individual
# modules, then putting them together to create a network.
module_1 <- random_module(1:10) # A module containing nodes 1-10
module_2 <- random_module(5:15) # A module containing nodes 5-15
# Create a network containing 20 nodes and the two modules. 
nw <- create_network_from_modules(20, list(module_1, module_2))
nw 
# Note: nodes 16-20 are not in a module, so they have no connections.
plot(nw)
}
