% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pphi.R
\name{pphi}
\alias{pphi}
\title{CDF of phi-divergence statitic under the null hypothesis.}
\usage{
pphi(q, n, s, beta)
}
\arguments{
\item{q}{- quantile, must be a scalar.}

\item{n}{- dimension parameter, i.e. the number of input statitics to construct phi-divergence statistic.}

\item{s}{- phi-divergence parameter. s = 2 is the higher criticism statitic.s = 1 is the Berk and Jones statistic.}

\item{beta}{- search range parameter . Beta must be between 1/n and 1.}
}
\value{
The left-tail probability of the null distribution of  phi-divergence statistic at the given quantile.
}
\description{
CDF of phi-divergence statitic under the null hypothesis.
}
\examples{
pval <- runif(10)
hcstat <- stat.phi(pval, 2, 0.5)$value
pphi(q=hcstat, n=10, s=2, beta=0.5)
}
\references{
1. Hong Zhang, Jiashun Jin and Zheyang Wu. "Distributions and Statistical Power of Optimal
Signal Detection Methods in Finite Samples", submitted.

2. Jager, Leah; Wellner, Jon A. "Goodness-of-fit tests via phi-divergences". Annals of Statistics 35 (2007).
}
\seealso{
\code{\link{stat.phi}} for the definition of the statistic.
}

