% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbj.R
\name{qbj}
\alias{qbj}
\title{Quantile of Berk-Jones statitic under the null hypothesis.}
\usage{
qbj(p, n, beta)
}
\arguments{
\item{p}{- a scalar left probability that defines the quantile.}

\item{n}{- dimension parameter, i.e. the number of input statitics to construct HC statistic.}

\item{beta}{- search range parameter . Beta must be between 1/n and 1.}
}
\value{
Quantile of BJ statistics.
}
\description{
Quantile of Berk-Jones statitic under the null hypothesis.
}
\examples{
## The 0.05 critical value of BJ statistic when n = 10:
qbj(p=.95, n=10, beta=0.5)
}
\references{
1. Hong Zhang, Jiashun Jin and Zheyang Wu. "Distributions and Statistical Power of Optimal
Signal Detection Methods in Finite Samples", submitted.

2. Donoho, David; Jin, Jiashun. "Higher criticism for detecting sparse heterogeneous mixtures". Annals of Statistics 32 (2004).

3. Berk, R.H. & Jones, D.H. Z. "Goodness-of-fit test statistics that dominate the Kolmogorov statistics". Wahrscheinlichkeitstheorie verw Gebiete (1979) 47: 47.
}
\seealso{
\code{\link{stat.bj}} for the definition of the statistic.
}

