% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rphi.R
\name{rphi}
\alias{rphi}
\title{Random number generation of phi-divergence statitics.}
\usage{
rphi(k, n, s, beta)
}
\arguments{
\item{k}{- number of observations.}

\item{n}{- dimension parameter, i.e. the number of input statitics to construct phi-divergence statistic.}

\item{s}{- phi-divergence parameter. s = 2 is the higher criticism statitic.s = 1 is the Berk and Jones statistic.}

\item{beta}{- search range parameter . Beta must be between 1/n and 1.}
}
\value{
Random number from phi-divergence statistics. The length of the result is determined by k for rphi.
}
\description{
Random number generation of phi-divergence statitics.
}
\examples{
## Generate a vector of 10 random numbers from Berk and Jones statistic when n = 100:
rphi(k=10, n=100, s=1, beta=1)
}
\references{
1. Hong Zhang, Jiashun Jin and Zheyang Wu. "Distributions and Statistical Power of Optimal
Signal Detection Methods in Finite Samples", submitted.

2. Jager, Leah; Wellner, Jon A. "Goodness-of-fit tests via phi-divergences". Annals of Statistics 35 (2007).
}
\seealso{
\code{\link{stat.phi}} for the definition of the statistic.
}

