% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{VariableFeaturePlot}
\alias{VariableFeaturePlot}
\alias{VariableGenePlot}
\alias{MeanVarPlot}
\title{View variable features}
\usage{
VariableFeaturePlot(
  object,
  cols = c("black", "red"),
  pt.size = 1,
  log = NULL,
  selection.method = NULL,
  assay = NULL,
  raster = NULL
)
}
\arguments{
\item{object}{Seurat object}

\item{cols}{Colors to specify non-variable/variable status}

\item{pt.size}{Size of the points on the plot}

\item{log}{Plot the x-axis in log scale}

\item{selection.method}{Which method to pull. For \code{HVFInfo} and
\code{VariableFeatures}, choose one from one of the
following:
\itemize{
 \item \dQuote{vst}
 \item \dQuote{sctransform} or \dQuote{sct}
 \item \dQuote{mean.var.plot}, \dQuote{dispersion}, \dQuote{mvp}, or
  \dQuote{disp}
}
For \code{SVFInfo} and \code{SpatiallyVariableFeatures}, choose from:
\itemize{
 \item \dQuote{markvariogram}
 \item \dQuote{moransi}
}}

\item{assay}{Assay to pull variable features from}

\item{raster}{Convert points to raster format, default is \code{NULL}
which will automatically use raster if the number of points plotted is greater than
100,000}
}
\value{
A ggplot object
}
\description{
View variable features
}
\examples{
data("pbmc_small")
VariableFeaturePlot(object = pbmc_small)

}
\seealso{
\code{\link{FindVariableFeatures}}
}
\concept{visualization}
