% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{ProjectIntegration}
\alias{ProjectIntegration}
\title{Integrate embeddings from the integrated sketched.assay}
\usage{
ProjectIntegration(
  object,
  sketched.assay = "sketch",
  assay = "RNA",
  reduction = "integrated_dr",
  features = NULL,
  layers = "data",
  reduction.name = NULL,
  reduction.key = NULL,
  method = c("sketch", "data"),
  ratio = 0.8,
  sketched.layers = NULL,
  seed = 123,
  verbose = TRUE
)
}
\arguments{
\item{object}{A Seurat object with all cells for one dataset}

\item{sketched.assay}{Assay name for sketched-cell expression (default is 'sketch')}

\item{assay}{Assay name for original expression (default is 'RNA')}

\item{reduction}{Dimensional reduction name for batch-corrected embeddings
in the sketched object (default is 'integrated_dr')}

\item{features}{Features used for atomic sketch integration}

\item{layers}{Names of layers for correction.}

\item{reduction.name}{Name to save new reduction as; defaults to
\code{paste0(reduction, '.orig')}}

\item{reduction.key}{Key for new dimensional reduction; defaults to creating
one from \code{reduction.name}}

\item{method}{Methods to construct sketch-cell representation
for all cells (default is 'sketch'). Can be one of:
\itemize{
 \item \dQuote{\code{sketch}}: Use random sketched data slot
 \item \dQuote{\code{data}}: Use data slot
}}

\item{ratio}{Sketch ratio of data slot when \code{dictionary.method} is set
to \dQuote{\code{sketch}}; defaults to 0.8}

\item{sketched.layers}{Names of sketched layers, defaults to all
layers of \dQuote{\code{object[[assay]]}}}

\item{seed}{A positive integer. The seed for the random number generator, defaults to 123.}

\item{verbose}{Print progress and message}
}
\value{
Returns a Seurat object with an integrated dimensional reduction
}
\description{
The main steps of this procedure are outlined below. For a more detailed
description of the methodology, please see Hao,  et al Biorxiv 2022:
\doi{10.1101/2022.02.24.481684}
}
\details{
First learn a atom dictionary representation to reconstruct each cell.
Then, using this dictionary representation,
reconstruct the embeddings of each cell from the integrated atoms.
}
