% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logmap.R
\name{intersect.LogMap}
\alias{intersect.LogMap}
\title{Find Common Logical Map Values}
\usage{
\method{intersect}{LogMap}(x, y = missing_arg(), ...)
}
\arguments{
\item{x}{A \code{LogMap} object}

\item{y}{Ignored}

\item{...}{Ignored}
}
\value{
The values of \code{x} that are present in \strong{every} observation
}
\description{
Identify values in a \link[=LogMap]{logical map} that are
common to every observation
}
\examples{
map <- LogMap(letters[1:10])
map[['obs']] <- c(1, 3, 7)
map[['entry']] <- c(2, 7, 10)

# Identify values that are present in every observation
intersect(map)

}
\seealso{
Logical map objects, validity, and interaction methods:
\code{\link{LogMap}},
\code{\link{LogMap-validity}},
\code{\link{as.matrix.LogMap}()},
\code{\link{droplevels.LogMap}()},
\code{\link{labels.LogMap}()}
}
\concept{logmap}
