% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDIFirt.R
\name{plotDIFirt}
\alias{plotDIFirt}
\title{Function for characteristic curve of DIF IRT model}
\usage{
plotDIFirt(parameters, test = "Lord", item = "all", item.name, same.scale = F)
}
\arguments{
\item{parameters}{numeric: data matrix or data frame. See \strong{Details}.}

\item{test}{character: type of statistic to be shown. See \strong{Details}.}

\item{item}{either character ("all"), or numeric vector, or single number
corresponding to column indicators. See \strong{Details}.}

\item{item.name}{character: the name of item.}

\item{same.scale}{logical: are the item \code{parameters} on the same scale?
(default is "FALSE"). See \strong{Details}.}
}
\description{
Plots characteristic curve of IRT model.
}
\details{
This function plots characteristic curve of DIF IRT model.

The \code{parameters} matrix has a number of rows equal to twice the number
of items in the data set. The first J rows refer to the item parameter estimates
in the reference group, while the last J ones correspond to the same items in the
focal group. The number of columns depends on the selected IRT model: 2 for the 1PL
model, 5 for the 2PL model, 6 for the constrained 3PL model and 9 for the
unconstrained 3PL model. The columns of irtParam have to follow the same structure
as the output of \code{itemParEst}, \code{difLord} or \code{difRaju} command from
\code{difR} package.

Two possible type of \code{test} statistics can be visualized - \code{"Lord"}
gives only characteristic curves, \code{"Raju"} also highlights area between
these curves.

For default option \code{"all"}, all characteristic curves are plotted.
}
\examples{
# loading libraries
library(difR)
library(ltm)

# loading data based on GMAT2
data(GMAT2, package = "difNLR")

# Estimation of 2PL IRT model and Lord's statistic
# by difR package
fitLord <- difLord(GMAT2, group = 21, focal.name = 1, model = "2PL")
# plot of item 1 and Lord's statistic
plotDIFirt(fitLord$itemParInit, item = 1)

# Estimation of 2PL IRT model and Raju's statistic
# by difR package
fitRaju <- difRaju(GMAT2, group = 21, focal.name = 1, model = "2PL")
# plot of item 1 and Lord's statistic
plotDIFirt(fitRaju$itemParInit, test = "Raju", item = 1)
}
\seealso{
\code{\link[difR]{itemParEst}}, \code{\link[difR]{difLord}}, \code{\link[difR]{difRaju}}
}
\author{
Adela Hladka \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
