% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SightabilityPopR_DomStrat.R
\name{SightabilityPopR_DomStrat}
\alias{SightabilityPopR_DomStrat}
\title{Classical and Domain Stratification using SightabilityPopR()}
\usage{
SightabilityPopR_DomStrat(
  stratum.data,
  selected.unit.data,
  waypoint.data,
  density = NULL,
  abundance = NULL,
  numerator = NULL,
  denominator = NULL,
  sight.formula = ~1,
  sight.beta = 10,
  sight.beta.cov = matrix(0, nrow = 1, ncol = 1),
  sight.logCI = TRUE,
  sight.var.method = c("Wong", "SS")[1],
  stratum.var = "Stratum",
  domain.var = "Domain",
  stratum.total.blocks.var = "Total.Blocks",
  stratum.total.area.var = "Total.Area",
  block.id.var = "Block.ID",
  block.area.var = "Block.Area",
  conf.level = 0.9
)
}
\arguments{
\item{stratum.data}{A data frame containing for each combination of stratum and domain, the stratum id (see stratum.var), 
the domain id (see domain.var),
the total number of blocks in the stratum (see stratum.total.blocks.var) and 
the total area of the stratum (see stratum.total.area.var)}

\item{selected.unit.data}{A data frame containing information on the selected survey units. Required variables
are the stratum (see stratum.var), domain (see domain.var), block.id (see block.id.var), and the
   area of the block (see block.area.var).}

\item{waypoint.data}{A data frame containing counts of moose in each group along with a variable identifying 
the stratum (see stratum.var), domain (see domain.var) and block (see block.id.var). Additional variables can
be included such as covariates for the sightability function (not currently used in MoosePopR)}

\item{density, abundance, numerator, denominator}{Right-handed formula identifying the variable(s) in the
waypoint data frame for which the density, abundance, or ratio (numerator/denominator) are to be estimated.}

\item{sight.formula}{A formula that identifies the model used
to estimate sightability. For example \code{observed ~ VegCoverClass} would indicate
that sightability is a function of the \code{VegCoverClass} variable in the survey 
data. The left hand variable is arbitrary. The right hand variables must be present
in the survey.data data frame.}

\item{sight.beta}{The vector of estimated coefficients for the logistic regression sightability model.}

\item{sight.beta.cov}{The covariance matrix of \code{sight.beta}}

\item{sight.logCI}{Should confidence intervals for the sightability adjusted estimates be computed
using a normal-based confidence interval on \code{log(abundance)}}

\item{sight.var.method}{What method should be used to estimate the variances after adjusting
for sightability.}

\item{stratum.var}{Name of the variable in the data frames that identifies the classical stratum}

\item{domain.var}{Name of the variable in the data frames that identifies the domain.}

\item{stratum.total.blocks.var}{Name of the variable in the stratum.data data frame that contains the total number of
blocks in the stratum.}

\item{stratum.total.area.var}{Name of the variable in the stratum.data data.frame that contains the total stratum area.}

\item{block.id.var}{Name of the variable in the data frames that identifies the block.id (the sampling unit)}

\item{block.area.var}{Name of the variable in data frames that contains the area of the blocks (area of sampling unit)}

\item{conf.level}{Confidence level used to create confidence intervals.}
}
\value{
A data frame containing for each stratum and for all combinations of strata and domains
 (identified as stratum id \code{.OVERALL}), the density,
   or abundance or ratio estimate along with its estimated standard error and large-sample normal-based confidence interval.
}
\description{
This function allows for classical or domain stratification when using SightabilityPopR().
Caution **SE are NOT adjusted for measurements on multiple domains on the same
sampling unit. Bootstrapping may be required**. Consult the vignette for more details.
 
 SightabilityPopR_DomStrat() adjusts for sightability < 100\%.
}
\examples{
 
##---- See the vignettes for examples on how to run this analysis.

}
\references{
To Be Added.
}
\author{
Schwarz, C. J. \email{cschwarz.stat.sfu.ca@gmail.com}.
}
\keyword{surveys}
\keyword{~MOOSEPOP}
\keyword{~moose}
