% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{GetCellsInRegion}
\alias{GetCellsInRegion}
\title{GetCellsInRegion}
\usage{
GetCellsInRegion(tabix, region, sep = c("-", "-"), cells = NULL)
}
\arguments{
\item{tabix}{Tabix object}

\item{region}{A string giving the region to extract from the fragments file}

\item{sep}{Vector of separators to use for genomic string. First element is used to separate chromosome
and coordinates, second separator is used to separate start and end coordinates.}

\item{cells}{Vector of cells to include in output. If NULL, include all cells}
}
\value{
Returns a list
}
\description{
Extract cell names containing reads mapped within a given genomic region
}
\examples{
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
GetCellsInRegion(tabix = fpath, region = "chr1-10245-762629")
}
