% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/peaks.R
\name{CallPeaks}
\alias{CallPeaks}
\alias{CallPeaks.Seurat}
\alias{CallPeaks.ChromatinAssay}
\alias{CallPeaks.Fragment}
\alias{CallPeaks.default}
\title{Call peaks}
\usage{
CallPeaks(object, ...)

\method{CallPeaks}{Seurat}(
  object,
  assay = NULL,
  group.by = NULL,
  idents = NULL,
  macs2.path = NULL,
  broad = FALSE,
  outdir = tempdir(),
  fragment.tempdir = tempdir(),
  combine.peaks = TRUE,
  effective.genome.size = 2.7e+09,
  extsize = 200,
  shift = -extsize/2,
  additional.args = NULL,
  name = Project(object),
  cleanup = TRUE,
  verbose = TRUE,
  ...
)

\method{CallPeaks}{ChromatinAssay}(
  object,
  macs2.path = NULL,
  outdir = tempdir(),
  broad = FALSE,
  effective.genome.size = 2.7e+09,
  extsize = 200,
  shift = -extsize/2,
  additional.args = NULL,
  name = "macs2",
  cleanup = TRUE,
  verbose = TRUE,
  ...
)

\method{CallPeaks}{Fragment}(
  object,
  macs2.path = NULL,
  outdir = tempdir(),
  broad = FALSE,
  effective.genome.size = 2.7e+09,
  extsize = 200,
  shift = -extsize/2,
  additional.args = NULL,
  name = "macs2",
  cleanup = TRUE,
  verbose = TRUE,
  ...
)

\method{CallPeaks}{default}(
  object,
  macs2.path = NULL,
  outdir = tempdir(),
  broad = FALSE,
  effective.genome.size = 2.7e+09,
  extsize = 200,
  shift = -extsize/2,
  additional.args = NULL,
  name = "macs2",
  cleanup = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A Seurat object, ChromatinAssay object, Fragment object, or the
path to fragment file/s.}

\item{...}{Arguments passed to other methods}

\item{assay}{Name of assay to use}

\item{group.by}{Grouping variable to use. If set, peaks will be called
independently on each group of cells and then combined. Note that to call
peaks using subsets of cells we first split the fragment file/s used, so
using a grouping variable will require extra time to split the files and
perform multiple MACS peak calls, and will store additional files on-disk
that may be large. Note that we store split fragment files in the temp
directory (\code{\link[base]{tempdir}}) by default, and if the program is
interrupted before completing these temporary files will not be removed. If
NULL, peaks are called using all cells together (pseudobulk).}

\item{idents}{List of identities to include if grouping cells (only valid if
also setting the \code{group.by} parameter). If NULL, peaks will be called
for all cell identities.}

\item{macs2.path}{Path to MACS program. If NULL, try to find MACS
automatically.}

\item{broad}{Call broad peaks (\code{--broad} parameter for MACS)}

\item{outdir}{Path for output files}

\item{fragment.tempdir}{Path to write temporary fragment files. Only used if
\code{group.by} is not NULL.}

\item{combine.peaks}{Controls whether peak calls from different groups of
cells are combined using \code{GenomicRanges::reduce} when calling peaks for
different groups of cells (\code{group.by} parameter). If FALSE, a list of
\code{GRanges} object will be returned. Note that metadata fields such as the
p-value, q-value, and fold-change information for each peak will be lost if
combining peaks.}

\item{effective.genome.size}{Effective genome size parameter for MACS
(\code{-g}). Default is the human effective genome size (2.7e9).}

\item{extsize}{\code{extsize} parameter for MACS.}

\item{shift}{\code{shift} parameter for MACS.}

\item{additional.args}{Additional arguments passed to MACS. This should be a
single character string}

\item{name}{Name for output MACS files. This will also be placed in the
\code{name} field in the GRanges output.}

\item{cleanup}{Remove MACS output files}

\item{verbose}{Display messages}
}
\value{
Returns a \code{\link[GenomicRanges]{GRanges}} object
}
\description{
Call peaks using MACS. Fragment files linked to the specified assay will be
used to call peaks. If multiple fragment files are present, all will be used
in a single MACS invocation. Returns the \code{.narrowPeak} MACS output as a
\code{GRanges} object.
}
\details{
See \url{https://macs3-project.github.io/MACS/} for MACS documentation.

If you call peaks using MACS2 please cite:
\doi{10.1186/gb-2008-9-9-r137}
}
\concept{quantification}
