\name{rmar.bcl}
\alias{rmar.bcl}
\title{
Simulating Correlated Nominal Multinomial Responses
}
\description{
This function generates correlated nominal multinomial responses assuming a threshold approach.
The threshold extends the priciple of maximum random utility and it gives rise to the marginal baseline category logit model.
The correlation structure refers to the correlation of the underlying latent variables.
}
\usage{
rmar.bcl(clsize, ncategories, lin.pred, cor.matrix)
}
\arguments{
  \item{clsize}{
integer indicating the common cluster size.
}
  \item{ncategories}{
integer indicating the number of categories.
}
  \item{lin.pred}{
matrix with \code{clsize} x \code{ncategories} columns. 
}
  \item{cor.matrix}{
matrix or vector that describes the correlation structure of the underlying latent variables. See details for more info.
}
}
\details{
\enumerate{
\item The row dimension of \code{lin.pred} equals the sample size.
\item If \code{cor.matrix} is a matrix, then the Li-Hammond method is used and \code{cor.matrix} equals the correlation matrix of the standard multivariate normal 
distribution. Otherwise random vectors from the multivariate Gumbel distribution are generated.
}
}
\value{
\item{Ysim}{the correlated nominal multinomial responses.}
\item{correlation}{the correlation matrix of the underlying continuous variables.}
\item{error}{the simulated noise of the underlying regression.}
}
\references{
Li, S.T. and Hammond, J.L. (1975). Generation of pseudorandom numbers with specified univariate distributions and correlation coefficients.
Systems, Man and Cybernetics, IEEE Transacions on 5, pp 557-561.

Gumbel, E.J. (1961). Multivariate extremal distributions. Bulletin de l'Institut International de Statistiques.
}
\author{
Anestis Touloumis
}
\seealso{
\code{\link{rtransfam}},\code{\link{rmar.cumlink}}
}
\examples{
\dontrun{
Generating correlated multinomial responses under a marginal baseline category 
logit model
}
rmar.bcl(clsize=3,ncategories=4,lin.pred=rmvnorm(10,sigma=diag(1,12)),cor.matrix=0.3)
}

