% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{ECR}
\alias{ECR}
\title{Compute the empirical coverage rate for Type I errors and Power}
\usage{
ECR(CIs, population)
}
\arguments{
\item{CIs}{a matrix of confidence interval values for a given population value, where the first
column indicates the lower confidence interval and the second column the upper confidence interval}

\item{population}{a numeric scalar indicating the fixed population value}
}
\description{
Computes the detection rate for determining empirical Type I error and power rates using information
from the confidence intervals. Note that using \code{1 - ECR(CIs, population)} will provide the empirical
detection rate.
}
\examples{

CIs <- matrix(NA, 100, 2)
for(i in 1:100){
   dat <- rnorm(100)
   CIs[i,] <- t.test(dat)$conf.int
}

ECR(CIs, 0)

}
\seealso{
\code{\link{EDR}}
}

