% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{check_error}
\alias{check_error}
\title{Check if object contains an error and stop flow}
\usage{
check_error(...)
}
\arguments{
\item{...}{objects that have been returned from a \code{\link{try}} call}
}
\description{
Check if the supplied object(s), which have previously been wrapped in a \code{\link{try}} function,
contain any errors. If so, this function will throw an error to stop the work-flow. This function
works sequentially, therefore the first object to demonstrate a \code{try-error} in the inputs
arguments will be the first to throw an error.
}
\examples{
\dontrun{

fun <- function(x) x + 1

res <- try(fun(1), silent = TRUE)
check_error(res) # no error thrown

res <- try(fun('this'), silent = TRUE)
check_error(res) # throws error

# multiple error check
res2 <- try(fun('that'), silent = TRUE)
check_error(res, res2)
}

}

