% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimDesign.R
\name{SimDesign}
\alias{SimDesign}
\alias{SimDesign-package}
\title{Structure for Organizing Monte Carlo Simulation Designs}
\description{
Structure for Organizing Monte Carlo Simulation Designs
}
\details{
Provides tools to help organize Monte Carlo simulations in R. The package
controls the structure and back-end of Monte Carlo simulations
by utilizing a general generate-analyse-summarise strategy. The functions provided control common
simulation issues such as re-simulating non-convergent results, support parallel
back-end and MPI distributed computations, save and restore temporary files,
aggregate results across independent nodes, and provide native support for debugging.
The primary function for organizing the simulations is \code{\link{runSimulation}}, while
for array jobs submitting to HPC clusters (e.g., SLURM) see \code{\link{runArraySimulation}}
and the associated package vignettes.

For an in-depth tutorial of the package please refer to
Chalmers and Adkins (2020; \doi{10.20982/tqmp.16.4.p248}).
For an earlier didactic presentation of the package users can refer to Sigal and Chalmers
(2016; \doi{10.1080/10691898.2016.1246953}). Finally, see the associated
wiki on Github (\url{https://github.com/philchalmers/SimDesign/wiki})
for other tutorial material, examples, and applications of \code{SimDesign} to real-world simulations.
}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{package}
