% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_script.R
\name{set_script}
\alias{set_script}
\title{Set the "simulation script"}
\usage{
set_script(sim, fn)
}
\arguments{
\item{sim}{A simulation object of class \code{sim_obj}, usually created by
\code{\link{new_sim}}}

\item{fn}{A function that runs a single simulation replicate and returns the
results. The results must be a list of key-value pairs. Values are
categorized as simple (a number, a character string, etc.) or complex
(vectors, dataframes, lists, etc.). Complex data must go inside a key
called ".complex" and the associated value must be a list (see examples).
The function body can contain references to the special object \code{L}
that stores the current set of simulation levels (see examples).
The keys must be valid R names (see ?make.names). Any functions used
within the script must be declared before \code{set_script} is called.}
}
\value{
The original simulation object with the new "simulation script"
    function added.
}
\description{
Specify a function to be used as the "simulation script". The
    simulation script is a function that runs a single simulation replicate
    and returns the results.
}
\examples{
# The following is a toy example of a simulation, illustrating the use of
# the set_script function.
sim <- new_sim()
create_data <- function(n) { rpois(n, lambda=5) }
est_mean <- function(dat, type) {
  if (type=="M") { return(mean(dat)) }
  if (type=="V") { return(var(dat)) }
}
sim \%<>\% set_levels(n=c(10,100,1000), est=c("M","V"))
sim \%<>\% set_config(num_sim=1)
sim \%<>\% set_script(function() {
  dat <- create_data(L$n)
  lambda_hat <- est_mean(dat=dat, type=L$est)
  return (list("lambda_hat"=lambda_hat))
})
sim \%<>\% run()
sim$results

# If you need to return complex result data (vectors, dataframes, lists,
# etc.), use the construct ".complex"=list().
sim <- new_sim()
sim \%<>\% set_levels(n=c(4,9))
sim \%<>\% set_config(num_sim=1)
sim \%<>\% set_script(function() {
  dat <- rnorm(L$n)
  mtx <- matrix(dat, nrow=sqrt(length(dat)))
  return (list(
    "mean" = mean(dat),
    "det" = det(mtx),
    ".complex" = list(dat=dat, mtx=mtx)
  ))
})
sim \%<>\% run()

}
