% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scheduled_events.R
\docType{class}
\name{scheduled_events-class}
\alias{scheduled_events-class}
\title{Class \code{"scheduled_events"}}
\description{
Class to handle the scheduled events
}
\section{Slots}{

\describe{
  \item{E}{
    Sparse matrix of object class \code{"\linkS4class{dgCMatrix}"}.
    Each row corresponds to one state in the compartment model. The
    non-zero entries in a column indicates the states to select and
    include in an event.  For the events \code{EXIT_EVENT},
    \code{INTERNAL_TRANSFER_EVENT} and \code{EXTERNAL_TRANSFER_EVENT},
    a non-zero entry in element \code{i} of select column \code{j}
    indicate the compartments to sample individuals from.  For the
    \code{ENTER_EVENT}, all individuals enter first non-zero compartment,
    i.e. a non-zero entry in element \code{i} of select column \code{j}.
  }
  \item{N}{
    For the \code{INTERNAL_TRANSFER_EVENT}, a non-zero entry in
    element \code{i} of select column \code{j} in \code{E} indicate
    the compartments to sample individuals from. The value of element
    \code{i} of column \code{k} in \code{N} determines the
    target compartment. The target compartment for sampled individuals
    is given by adding the value.
  }
  \item{event}{
    Integer vector of length \code{len} with scheduled events.
    The following four type events exists; \code{EXIT_EVENT = 0},
    \code{ENTER_EVENT = 1}, \code{INTERNAL_TRANSFER_EVENT = 2}, and
    \code{EXTERNAL_TRANSFER_EVENT = 3}.
  }
  \item{time}{
    Integer vector of length \code{len} with the time for the event.
  }
  \item{node}{
    Integer vector of length \code{len}. The node of the event \code{i}.
  }
  \item{dest}{
    Integer vector of length \code{len}. The destination node for a
    \code{EXTERNAL_TRANSFER_EVENT}.
  }
  \item{n}{
    Integer vector of length \code{len}. The number of individuals in the
    event. n[i] >= 0.
  }
  \item{proportion}{
    Numeric vector of length \code{len}. If n[i] equals zero,
    then the number of individuals to sample is calculated by summing
    the number of individuals in the states determined by
    select[i] and multiplying with the proportion.
    0 <= proportion[i] <= 1.
  }
  \item{select}{
    Integer vector of length \code{len}. Column \code{j} in the event
    matrix \code{E} that determines the states to sample from.
  }
  \item{shift}{
    Integer vector of length \code{len}. Column j in the matrix
    \code{N} that determines how to move the sampled states in an
    \code{INTERNAL_TRANSFER_EVENT}. Should be \code{-1} for the other
    event types.
  }
}
}
\keyword{methods}

