% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc.R
\docType{class}
\name{SimInf_abc-class}
\alias{SimInf_abc-class}
\title{Class \code{"SimInf_abc"}}
\description{
Class \code{"SimInf_abc"}
}
\section{Slots}{

\describe{
\item{\code{model}}{The \code{SimInf_model} object to estimate parameters
in.}

\item{\code{priors}}{A \code{data.frame} containing the four columns
\code{parameter}, \code{distribution}, \code{p1} and
\code{p2}. The column \code{parameter} gives the name of the
parameter referred to in the model. The column
\code{distribution} contains the name of the prior
distribution. Valid distributions are 'gamma', 'normal' or
'uniform'. The column \code{p1} is a numeric vector with the
first hyperparameter for each prior: 'gamma') shape,
'lognormal') logmean, 'normal') mean, and 'uniform') lower
bound. The column \code{p2} is a numeric vector with the
second hyperparameter for each prior: 'gamma') rate,
'lognormal') standard deviation on the log scale, 'normal')
standard deviation, and 'uniform') upper bound.}

\item{\code{target}}{Character vector (\code{gdata} or \code{ldata}) that
determines if the ABC-SMC method estimates parameters in
\code{model@gdata} or in \code{model@ldata}.}

\item{\code{pars}}{Index to the parameters in \code{target}.}

\item{\code{nprop}}{An integer vector with the number of simulated
proposals in each generation.}

\item{\code{fn}}{A function for calculating the summary statistics for the
simulated trajectory and determine the distance for each
particle, see \code{\link{abc}} for more details.}

\item{\code{tolerance}}{A numeric matrix (number of summary statistics
\eqn{\times} number of generations) where each column contains
the tolerances for a generation and each row contains a
sequence of gradually decreasing tolerances.}

\item{\code{x}}{A numeric array (number of particles \eqn{\times} number
of parameters \eqn{\times} number of generations) with the
parameter values for the accepted particles in each
generation. Each row is one particle.}

\item{\code{weight}}{A numeric matrix (number of particles \eqn{\times}
number of generations) with the weights for the particles
\code{x} in the corresponding generation.}

\item{\code{distance}}{A numeric array (number of particles \eqn{\times}
number of summary statistics \eqn{\times} number of
generations) with the distance for the particles \code{x} in
each generation. Each row contains the distance for a particle
and each column contains the distance for a summary statistic.}

\item{\code{ess}}{A numeric vector with the effective sample size (ESS) in
each generation. The effective sample size is computed as
\deqn{\left(\sum_{i=1}^N\!(w_{g}^{(i)})^2\right)^{-1},}{1 /
(sum(w_ig^2)),} where \eqn{w_{g}^{(i)}}{w_ig} is the
normalized weight of particle \eqn{i} in generation \eqn{g}.}

\item{\code{init_model}}{An optional function that, if non-NULL, is
applied before running each proposal. The function must accept
one argument of type \code{SimInf_model} with the current
model of the fitting process. This function can be useful to
specify the initial state of \code{u0} or \code{v0} of the
model before running a trajectory with proposed parameters.}
}}

\seealso{
\code{\link{abc}} and \code{\link{continue_abc}}.
}
