% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIR.R
\name{SIR}
\alias{SIR}
\title{Create a SIR model}
\usage{
SIR(u0, tspan, events = NULL, beta = NULL, gamma = NULL)
}
\arguments{
\item{u0}{A \code{data.frame} with the initial state in each node,
see details.}

\item{tspan}{An increasing sequence of points in time where the
state of the system is to be returned.}

\item{events}{a \code{data.frame} with the scheduled events, see
\code{\link{siminf_model}}.}

\item{beta}{The transmission rate from susceptible to infected.}

\item{gamma}{The recovery rate from infected to recovered.}
}
\value{
\code{SIR}
}
\description{
Create a SIR model to be used by the simulation framework.
}
\details{
The argument \code{u0} must be a \code{data.frame} with one row for
each node with the following columns:
\describe{
\item{S}{The number of sucsceptible in each node}
\item{I}{The number of infected in each node}
\item{R}{The number of recovered in each node}
}
}
\examples{
## Create a SIR model object.
model <- SIR(u0 = data.frame(S = 99, I = 1, R = 0),
             tspan = 1:100,
             beta = 0.16,
             gamma = 0.077)

## Run the SIR model and plot the result.
result <- run(model, seed = 123)
plot(result)
}

