% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/SimInf_model.R
\docType{methods}
\name{V}
\alias{V}
\alias{V,SimInf_model-method}
\title{Extract the continuous state variables}
\usage{
V(model)

\S4method{V}{SimInf_model}(model)
}
\arguments{
\item{model}{The \code{model} to extract the result matrix from.}
}
\value{
The continuous state variables
}
\description{
The result matrix for the real-valued continuous state. \code{V[,
j]} contains the real-valued state of the system at
\code{tspan[j]}. The dimension of the matrix is
\eqn{N_n}\code{dim(ldata)[1]} \eqn{\times} \code{length(tspan)}.
}
\examples{
## Create an 'SISe' model with 6 nodes and initialize
## it to run over 10 days.
u0 <- data.frame(S = 100:105, I = 1:6)
model <- SISe(u0 = u0, tspan = 1:10,
              phi = rep(0, 6),
              upsilon = 0.017,
              gamma   = 0.1,
              alpha   = 1,
              beta_t1 = 0.19,
              beta_t2 = 0.085,
              beta_t3 = 0.075,
              beta_t4 = 0.185,
              end_t1  = 91,
              end_t2  = 182,
              end_t3  = 273,
              end_t4  = 365,
              epsilon = 0.000011)

## Run the model
result <- run(model, seed = 123)

## Extract the continuous state variables in each node at the
## time-points in tspan. In the 'SISe' model, V represent the
## environmental infectious pressure phi.
V(result)
}
\keyword{methods}
