% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimInf_events.R
\name{SimInf_events}
\alias{SimInf_events}
\title{Create a \code{"\linkS4class{SimInf_events}"} object}
\usage{
SimInf_events(E = NULL, N = NULL, events = NULL, t0 = NULL)
}
\arguments{
\item{E}{Sparse matrix of object class
\code{"\linkS4class{dgCMatrix}"} that selects the states to
include for sampling in an event.}

\item{N}{Sparse matrix of object class
\code{"\linkS4class{dgCMatrix}"} that determines how to shift
the states in an \code{INTERNAL_TRANSFER_EVENT}.}

\item{events}{A \code{data.frame} with events.}

\item{t0}{If \code{events$time} is a \code{Date} vector, then
\code{t0} determines the offset to match the time of the
events to the model \code{tspan} vector, see details. If
\code{events$time} is a numeric vector, then \code{t0} must be
\code{NULL}.}
}
\value{
S4 class \code{SimInf_events}
}
\description{
The argument events must be a \code{data.frame} with the following
columns:
\describe{
  \item{event}{
    Type of event: 0) \emph{exit}, 1) \emph{enter}, 2)
    \emph{internal transfer}, and 3) \emph{external transfer}.
    Other values are reserved for future event types and not
    supported by the current default core solver.
  }
  \item{time}{
    Time for the event. Can be either an \code{integer} or a
    \code{Date} vector.  A \code{Date} vector is coerced to a
    numeric vector as days, where \code{t0} determines the offset
    to match the time of the events to the model \code{tspan}
    vector.
  }
  \item{node}{
    The node that the event operates on. Also the source node for
    an \emph{external transfer} event.
    1 <= \code{node[i]} <= Number of nodes.
  }
  \item{dest}{
    The destination node for an \emph{external transfer} event.
    Should be \code{0} for the other event types. dest[i] >= 0.
  }
  \item{n}{
    The number of individuals affected by the event. n[i] >= 0.
  }
  \item{proportion}{
    If \code{n[i]} equals zero, the number of individuals affected by
    \code{event[i]} is calculated by summing the number of individuls
    with \code{proportion[i]}. 0 <= proportion[i] <= 1.
  }
  \item{select}{
    The column \code{j} in the event matrix \code{E} that
    determines the compartments that the event operates on.
  }
  \item{shift}{
    The column \code{k} in the shift matrix \code{N} that
    determines how individuals in \emph{internal transfer} and
    \emph{external transfer} events are shifted to enter another
    compartment.  Should be \code{0} for the other event types.
  }
}
}
