% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimInf_events.R
\docType{class}
\name{SimInf_events-class}
\alias{SimInf_events-class}
\title{Class \code{"SimInf_events"}}
\description{
Class to handle the scheduled events
}
\section{Slots}{

\describe{
  \item{E}{
    Each row corresponds to one compartment in the model. The
    non-zero entries in a column indicates the compartments to
    include in an event.  For the \emph{exit}, \emph{internal
    transfer} and \emph{external transfer} events, a non-zero
    entry indicate the compartments to sample individuals from.
    For the \emph{enter} event, all individuals enter first
    non-zero compartment. Sparse matrix of object class
    \code{"\linkS4class{dgCMatrix}"}.
  }
  \item{N}{
    Each row represents one compartment in the model and the
    values determine how to move sampled individuals in
    \emph{internal transfer} and \emph{external transfer} events.
  }
  \item{event}{
    Type of event: 0) \emph{exit}, 1) \emph{enter}, 2)
    \emph{internal transfer}, and 3) \emph{external transfer}.
    Other values are reserved for future event types and not
    supported by the current default core solver. Integer vector.
  }
  \item{time}{
    Time for the event. Integer vector.
  }
  \item{node}{
    The node that the event operates on. Also the source node for
    an \emph{external transfer} event.  Integer vector.
    1 <= \code{node[i]} <= Number of nodes.
  }
  \item{dest}{
    The destination node for an \emph{external transfer} event.
    Should be \code{0} for the other event types.
    Integer vector. dest[i] >= 0.
  }
  \item{n}{
    The number of individuals affected by the event. Integer vector.
    n[i] >= 0.
  }
  \item{proportion}{
    If \code{n[i]} equals zero, the number of individuals affected by
    \code{event[i]} is calculated by summing the number of individuls
    with \code{proportion[i]}. Numeric vector.
    0 <= proportion[i] <= 1.
  }
  \item{select}{
    The column \code{j} in the event matrix \code{E} that
    determines the compartments that the event operates
    on. Integer vector.
  }
  \item{shift}{
    The column \code{k} in the shift matrix \code{N} that
    determines how individuals in \emph{internal transfer} and
    \emph{external transfer} events are shifted to enter another
    compartment.  Should be \code{0} for the other event types.
    Integer vector.
  }
}
}

\keyword{methods}
