% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/SEIR.R, R/SIR.R, R/SISe.R,
%   R/SISe3.R, R/SISe3_sp.R, R/SISe_sp.R
\docType{methods}
\name{infected}
\alias{infected}
\alias{infected,SEIR-method}
\alias{infected,SIR-method}
\alias{infected,SISe-method}
\alias{infected,SISe3-method}
\alias{infected,SISe3_sp-method}
\alias{infected,SISe_sp-method}
\title{Infected}
\usage{
infected(model, ...)

\S4method{infected}{SEIR}(model, i = NULL, ...)

\S4method{infected}{SIR}(model, i = NULL, ...)

\S4method{infected}{SISe}(model, i = NULL, ...)

\S4method{infected}{SISe3}(model, age = 1:3, i = NULL, ...)

\S4method{infected}{SISe3_sp}(model, age = 1:3, i = NULL, ...)

\S4method{infected}{SISe_sp}(model, i = NULL, ...)
}
\arguments{
\item{model}{The \code{model} to extract the infected from}

\item{...}{Additional arguments affecting the measure}

\item{i}{Indices specifying the nodes to include when extracting
the number of infected. Default is NULL, which includes all nodes.}

\item{age}{For models with age categories, the age category to
extract.}
}
\description{
Extracts the number of infected
}
\examples{
## Create an 'SIR' model with 5 nodes and initialize
## it to run over 10 days.
u0 <- data.frame(S = rep(99, 5), I = rep(1, 5), R = rep(0, 5))
model <- SIR(u0 = u0, tspan = 1:10, beta = 0.16, gamma = 0.077)

## Run the model and save the result
result <- run(model, threads = 1, seed = 1)

## Extract the number of infected individuals in each
## node after each time step in the simulation
infected(result)

## Extract the number of infected individuals in the
## first node after each time step in the simulation
infected(result, i = 1)

## Extract the number of infected individuals in the
## first and fifth node after each time step in the simulation
infected(result, i = c(1, 5))
}
\keyword{methods}
