% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj_grad.R
\name{adj_grad}
\alias{adj_grad}
\title{Convert Non-Positive-Definite Correlation Matrix to Positive-Definite Matrix Using the Adjusted Gradient Updating Method}
\usage{
adj_grad(Sigma = NULL, B1 = NULL, tau = 0.5, tol = 0.1, steps = 100,
  msteps = 10)
}
\arguments{
\item{Sigma}{the non-PD correlation matrix}

\item{B1}{the initial matrix for algorithm; if NULL, uses a scaled initial matrix with diagonal elements \code{sqrt(nrow(Sigma))/2}}

\item{tau}{parameter used to calculate theta}

\item{tol}{maximum error for Frobenius norm distance between new matrix and original matrix}

\item{steps}{maximum number of steps for k (default = 100)}

\item{msteps}{maximum number of steps for m (default = 10)}
}
\value{
list with \code{Sigma2} the new correlation matrix, \code{dist} the Frobenius norm distance between \code{Sigma2} and \code{Sigma},
    \code{eig0} original eigenvalues of \code{Sigma}, \code{eig2} eigenvalues of \code{Sigma2}
}
\description{
This function converts a non-positive-definite correlation matrix to a positive-definite matrix using the
    adjusted gradient updating method with initial matrix \code{B1}.
}
\examples{
Sigma <- matrix(c(1, 0, 0.8, 0, 1, 0.8, 0.8, 0.8, 1), 3, 3, byrow = TRUE)
adj_grad(Sigma)

}
\references{
S Maree (2012). Correcting Non Positive Definite Correlation Matrices. BSc Thesis Applied Mathematics, TU Delft.
  \url{http://resolver.tudelft.nl/uuid:2175c274-ab03-4fd5-85a9-228fe421cdbf}.

JF Yin and Y Zhang (2013). Alternative gradient algorithms for computing the nearest correlation matrix.
    Applied Mathematics and Computation, 219(14): 7591-7599. \url{https://doi.org/10.1016/j.amc.2013.01.045}.

Y Zhang and JF Yin. Modified alternative gradients algorithm for computing the nearest correlation matrix.
    Internal paper of the Tongji University, Shanghai.
}
