% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_survey.R
\name{sim_sets}
\alias{sim_sets}
\title{Simulate survey sets}
\usage{
sim_sets(
  sim,
  subset_cells,
  n_sims = 1,
  trawl_dim = c(1.5, 0.02),
  min_sets = 2,
  set_den = 2/1000,
  resample_cells = FALSE
)
}
\arguments{
\item{sim}{A simulation object returned by \code{\link[=sim_distribution]{sim_distribution()}}.}

\item{subset_cells}{A logical expression to filter elements of the survey grid.
Can reference columns like \code{x}, \code{y}, \code{depth}, \code{cell}, \code{division}, \code{strat}, or \code{year}
(e.g., \code{cell < 100} or \code{year == 3}).}

\item{n_sims}{Number of survey simulations to generate.}

\item{trawl_dim}{Numeric vector specifying trawl width and distance (same units as the grid).}

\item{min_sets}{Minimum number of sets per stratum.}

\item{set_den}{Set density (number of sets per unit area).}

\item{resample_cells}{Logical. If \code{TRUE}, allows resampling of grid cells.
Note: allowing resampling may introduce bias, since depletion is applied at the cell level.}
}
\value{
A \code{data.table} containing details of each survey set location.
}
\description{
Simulates survey set locations from a population generated by \code{\link[=sim_distribution]{sim_distribution()}}.
Often used prior to running \code{\link[=sim_survey]{sim_survey()}}.
}
\examples{
\donttest{
sim <- sim_abundance(ages = 1:5, years = 1:5) |>
  sim_distribution(grid = make_grid(res = c(20, 20)))

# Define different sets for early and later years
standard_sets <- sim_sets(sim, year <= 2, set_den = 2 / 1000)
reduced_sets <- sim_sets(sim, year > 2 & !cell \%in\% 1:100, set_den = 1 / 1000)
sets <- rbind(standard_sets, reduced_sets)
sets$set <- seq(nrow(sets))  # Ensure each set has a unique ID

survey <- sim_survey(sim, custom_sets = sets)

plot_survey(survey, which_year = 3, which_sim = 1)
}
}
