% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleSize_Mielke.R
\name{sampleSize_Mielke}
\alias{sampleSize_Mielke}
\title{Sample Size Estimation for Multiple Hypothesis Testing Using Mielke's Method}
\usage{
sampleSize_Mielke(
  power,
  Nmax,
  m,
  k,
  rho,
  sigma,
  true.diff,
  equi.tol,
  design,
  alpha,
  adjust = "no",
  seed = NULL,
  nsim = 10000
)
}
\arguments{
\item{power}{Numeric. Desired statistical power.}

\item{Nmax}{Integer. Maximum allowable sample size.}

\item{m}{Integer. Total number of endpoints.}

\item{k}{Integer. Number of endpoints that must meet the success criteria for overall study success.}

\item{rho}{Numeric. Constant correlation coefficient among endpoints.}

\item{sigma}{Numeric or vector. Standard deviation of each endpoint. If a single value is provided, it is assumed to be constant across all endpoints. In a 2x2 crossover design, this is the within-subject standard deviation; in a parallel design, it represents the treatment group’s standard deviation, assumed to be the same for both test and reference.}

\item{true.diff}{Numeric or vector. Assumed true difference between test and reference for each endpoint. If a single value is provided, it is applied uniformly across all endpoints.}

\item{equi.tol}{Numeric. Equivalence margin; the equivalence interval is defined as (-equi.tol, +equi.tol).}

\item{design}{Character. Study design, either "22co" for a 2x2 crossover design or "parallel" for a parallel groups design.}

\item{alpha}{Numeric. Significance level for the hypothesis test.}

\item{adjust}{Character. Method for multiplicity adjustment; options are "no" (no adjustment), "bon" (Bonferroni adjustment), and "k" (k-adjustment).}

\item{seed}{Integer. Random seed for reproducibility.}

\item{nsim}{Integer. Number of simulations to run for power estimation (default: 10,000).}
}
\value{
A named vector containing:
\describe{
\item{"power.a"}{Achieved power with the estimated sample size.}
\item{"SS"}{Required sample size per sequence to achieve the target power.}
}
}
\description{
Estimates the required sample size to achieve a specified power level for multiple hypothesis testing, using the approach described by Mielke et al. (2018). This function is particularly useful for bioequivalence or biosimilar studies with multiple correlated endpoints, where a minimum number of endpoints must meet equivalence criteria.
}
\details{
This function uses the method proposed by Mielke et al. (2018) to estimate the sample size required to achieve the desired power level in studies with multiple correlated endpoints. The function iteratively increases sample size until the target power is reached or the maximum allowable sample size (Nmax) is exceeded. The approach accounts for endpoint correlation and supports adjustments for multiple testing using various correction methods.
}
\examples{
# Example 1 from Mielke
sampleSize_Mielke(power = 0.8, Nmax = 1000, m = 5, k = 5, rho = 0,
                  sigma = 0.3, true.diff =  log(1.05), equi.tol = log(1.25),
                  design = "parallel", alpha = 0.05, adjust = "no",
                  seed = 1234, nsim = 100)

}
\references{
Mielke, J., Jones, B., Jilma, B. & König, F. Sample Size for Multiple Hypothesis Testing in Biosimilar Development. Statistics in Biopharmaceutical Research 10, 39–49 (2018).
}
