% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reli_stats.R
\name{reli_stats}
\alias{reli_stats}
\title{Reliability Statistics}
\usage{
reli_stats(
  measure,
  item,
  id,
  data,
  wide = FALSE,
  col.names = NULL,
  conf.level = 0.95
)
}
\arguments{
\item{measure}{Name of column containing the measurement of interest}

\item{item}{Name of column containing the items. If this is a test-retest reliability study then this would indicate the time point (e.g., time1,time2, time3, etc.)}

\item{id}{Column with subject identifier}

\item{data}{Data frame with all data}

\item{wide}{Logical value (TRUE or FALSE) indicating if data is in a "wide" format. Default is TRUE.}

\item{col.names}{If wide is equal to TRUE then col.names is a list of the column names containing the measurements for reliability analysis.}

\item{conf.level}{the confidence level required. Default is 95\%.}
}
\value{
Returns single list with the results of the agreement analysis.

\describe{
  \item{\code{"icc"}}{Table of ICC results}
  \item{\code{"lmer"}}{Linear mixed model from lme4}
  \item{\code{"anova"}}{Analysis of Variance table}
  \item{\code{"var_comp"}}{Table of Variance Components}
  \item{\code{"n.id"}}{Number of subjects/participants}
  \item{\code{"n.items"}}{Number of items/time points}
  \item{\code{"cv"}}{Coefficient of Variation}
  \item{\code{"SEM"}}{Standard Error of Measurement}
  \item{\code{"SEE"}}{Standard Error of the Estimate}
  \item{\code{"SEP"}}{Standard Error of Predicitions}
  \item{\code{"plot.reliability"}}{Plot of data points within subjects across items}


}
}
\description{
reli_stats produces reliability statistics desccribed by Weir (2005). This includes intraclass correlation coefficients, the coefficient of variation, and the standard error of meassurement.
}
\section{References}{

Weir, J. P. (2005). Quantifying test-retest reliability using the intraclass correlation coefficient and the SEM. The Journal of Strength & Conditioning Research, 19(1), 231-240.
}

\examples{
data('reps')
reli_stats(data = reps, wide = TRUE, col.names = c("x","y"))

}
