% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.displacement.R
\name{plot.displacement}
\alias{plot.displacement}
\title{Plots the displacement from a particular point over a chosen window}
\usage{
\method{plot}{displacement}(x, y, Name, t, R, t_a, t_1, t_2, ...)
}
\arguments{
\item{x}{array of the x-coordinates describing the trajectory}

\item{y}{array of the y-coordinates describing the trajectory}

\item{Name}{name of the data, which is used for any saved files and plot titles}

\item{t}{an array of the times that the positions are recorded at}

\item{R}{radius value to use}

\item{t_a}{starting time to calculate the displacement from}

\item{t_1}{start of interval to view the displacement over}

\item{t_2}{end of interval to view the displacement over}

\item{...}{additional arguments to \link[graphics]{plot}}
}
\value{
Plot of the displacement
}
\description{
The displacement from a particular point to every other point along the animal's trajectory is calculated and this is then plotted over a defined window.
}
\details{
The displacement from a particular time point (\code{t_a}) to every other point along the trajectory is calculated and this is then plotted over a defined window [\code{t_1}, \code{t_2}]. A line representing the radius is also drawn to see when the trajectory enters or leaves the circle centred at the point (\code{t_a}). This plot can be used to see how far away the animal moves after leaving a particular circle.
}
\examples{
##Load the data
data(OU_14)
t=unlist(OU_14["t"])
X=unlist(OU_14["X"])
Y=unlist(OU_14["Y"])

class(X) = "displacement"
class(Y) = "displacement"

##Plot the displacement from the starting point (t=0) for t=0 to t=2.9999
plot(X, Y, "OU14", t, 0.3, 0, 0, 2.9999)
}
\references{
Munden, R., Borger , L., Wilson, R.P., Redcliffe, J., Loison, A., Garel, M. and Potts, J.P. in review. Making sense of ultra-high-resolution movement data: an algorithm for inferring sites of interest.
}
\author{
Rhys Munden <rdmunden1@sheffield.ac.uk>
}
\keyword{Plots}
