% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Celltype_annotation_Box.R
\name{Celltype_annotation_Box}
\alias{Celltype_annotation_Box}
\title{Uses "marker_list" to generate Box plot for cell annotation}
\usage{
Celltype_annotation_Box(
  seurat_obj,
  gene_list,
  species,
  cluster_col = "seurat_clusters",
  assay = "RNA",
  save_path = NULL,
  metric_names = NULL
)
}
\arguments{
\item{seurat_obj}{Enter the Seurat object with annotation columns such as
"seurat_cluster" in meta.data to be annotated.}

\item{gene_list}{A list of cells and corresponding gene controls, the name of
the list is cell type, and the first column of the list corresponds to markers.
Lists can be generated using functions such as "Markers_filter_Cellmarker2 ()",
"Markers_filter_PanglaoDB ()", "read_excel_markers ()", "read_seurat_markers ()", etc.}

\item{species}{This parameter selects the species "Human" or "Mouse" for standard
gene format correction of markers entered by "Marker_list".}

\item{cluster_col}{Enter annotation columns such as "seurat_cluster" in meta.data
of the Seurat object to be annotated. Default parameters use "cluster_col =
"seurat_clusters"".}

\item{assay}{Enter the assay used by the Seurat object, such as "RNA". Default
parameters use "assay = "RNA"".}

\item{save_path}{The output path of the cell annotation picture. Default parameters
use "save_path = "./SlimR/Celltype_annotation_Bar/"".}

\item{metric_names}{Warning: Do not enter information. This parameter is used to
check if "Marker_list" conforms to the SlimR output.}
}
\value{
The cell annotation picture is saved in "save_path".
}
\description{
Uses "marker_list" to generate Box plot for cell annotation
}
\examples{
\dontrun{Celltype_annotation_Box(seurat_obj = sce,
         gene_list = Markers_list,
         species = "Human",
         cluster_col = "seurat_clusters",
         assay = "RNA",
         save_path = file.path(tempdir(),"SlimR_Celltype_annotation_Box")
         )
         }

}
