% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Celltype_annotation_Cellmarker2.R
\name{Celltype_annotation_Cellmarker2}
\alias{Celltype_annotation_Cellmarker2}
\title{Uses "marker_list" from Cellmarker2 for cell annotation}
\usage{
Celltype_annotation_Cellmarker2(
  seurat_obj,
  gene_list,
  species,
  cluster_col = "seurat_clusters",
  assay = "RNA",
  save_path = NULL,
  min_counts = 1
)
}
\arguments{
\item{seurat_obj}{Enter the Seurat object with annotation columns such as
"seurat_cluster" in meta.data to be annotated.}

\item{gene_list}{Enter the standard "Marker_list" generated by the Cellmarker2
database for the SlimR package, generated by the "Markers_filter_Cellmarker2 ()"
function.}

\item{species}{This parameter selects the species "Human" or "Mouse" for standard
gene format correction of markers entered by "Marker_list".}

\item{cluster_col}{Enter annotation columns such as "seurat_cluster" in meta.data
of the Seurat object to be annotated. Default parameters use "cluster_col =
"seurat_clusters"".}

\item{assay}{Enter the assay used by the Seurat object, such as "RNA". Default
parameters use "assay = "RNA"".}

\item{save_path}{The output path of the cell annotation picture. Default parameters
use "save_path = "./SlimR/Celltype_annotation_Cellmarker2/"".}

\item{min_counts}{The minimum number of counts of genes in "Marker_list" entered.
This number represents the number of the same gene in the same species and
the same location in the Cellmarker2 database used for annotation of this cell
type. Default parameters use "min_counts = 1".}
}
\value{
The cell annotation picture is saved in "save_path".
}
\description{
Uses "marker_list" from Cellmarker2 for cell annotation
}
\examples{
\dontrun{Celltype_annotation_Cellmarker2(seurat_obj = sce,
         gene_list = Markers_list_Cellmarker2,
         species = "Human",
         cluster_col = "seurat_clusters",
         assay = "RNA",
         save_path = file.path(tempdir(),"SlimR_Celltype_annotation_Cellmarker2")
         )
         }

}
