% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lift-adat.R
\name{lift_adat}
\alias{lift_adat}
\title{Lift an ADAT Between Assay Versions}
\usage{
lift_adat(adat, anno.tbl)
}
\arguments{
\item{adat}{A \code{soma_adat} class object.}

\item{anno.tbl}{A table of annotations, typically the result of a call
to \code{\link[=read_annotations]{read_annotations()}}.}
}
\value{
A "lifted" \code{soma_adat} object corresponding to the scaling
reference in the \code{anno.tbl}. RFU values are rounded to 1 decimal to
match standard SomaScan delivery format.
}
\description{
The SomaScan platform continually improves its technical processes
between assay versions; from changing reagents, liquid handling equipment,
and increased analyte content. However, these upgrades can result in
minute differences in RFU space for a given analyte, requiring a calibration
(aka "lifting" or "bridging") to bring RFUs into a comparable space.
This is accomplished by applying an analyte-specific scalar to each analyte
RFU (ADAT column). The scalar values themselves are typically provided
via \verb{*.xlsx} file, which can be parsed via \code{\link[=read_annotations]{read_annotations()}}. See Details.
}
\details{
Lifting between various versions requires a specific
annotations file containing scalars specific to desired lifting direction.
For example, to "lift" between \code{v4.1} -> \code{v4.0}, you \emph{must} be working
with SomaScan data in \code{v4.1} space and an annotations file containing
scalars to convert \strong{to} \code{v4.0}.
Likewise, "lifting" from \code{v4.0} -> \code{v4.1} requires
a separate annotations file and a \code{soma_adat} from SomaScan \code{v4.0}.
}
\examples{
# `example_data` is SomaScan V4
adat <- head(example_data, 3L)

# read in version specific annotations file
# containing scaling values between assay versions
\dontrun{
tbl <- read_annotations("path/to/annotations_file.xlsx")
}

# mock annotations table in lieu of `*.xlsx` file
tbl <- tibble::tibble(SeqId = getSeqId(getAnalytes(adat)),
                     "Plasma Scalar v4.0 to v4.1" = 1)   # scale by 1.0
# usually performed inside `read_annotations()`
# assign valid testing version to annotations table
attr(tbl, "version") <- "SL-99999999-rev99-1999-01"

# perform the 'lifting'
lifted <- lift_adat(adat, tbl)

# `tbl` contained all scalars = 1.0 (same RFUs)
all.equal(adat, lifted, check.attributes = FALSE)

# attributes updated to reflect the 'lift'
attr(lifted, "Header")$HEADER$ProcessSteps
attr(lifted, "Header")$HEADER$SignalSpace
}
