% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffAdats.R
\name{diffAdats}
\alias{diffAdats}
\title{Diff Two ADAT Objects}
\usage{
diffAdats(adat1, adat2, tolerance = 1e-06)
}
\arguments{
\item{adat1, adat2}{Two \code{soma_adat} objects to compare.}

\item{tolerance}{Numeric \verb{> 0}. Differences smaller than tolerance are
not triggered. See \code{\link[=all.equal]{all.equal()}}.}
}
\value{
\code{NULL}, invisibly. Called for side effects.
}
\description{
Diff tool for the differences between two \code{soma_adat} objects.
When diffs of the table \emph{values} are interrogated, \strong{only}
the intersect of the column meta data or feature data is considered
}
\note{
Only diffs of the column name \emph{intersect} are reported.
}
\examples{
# subset `example_data` for speed
# all SeqIds from 2000 -> 2999
seqs <- grep("^seq\\\\.2[0-9]{3}", names(example_data), value = TRUE)
ex_data_small <- head(example_data[, c(getMeta(example_data), seqs)], 10L)
dim(ex_data_small)

# no diff to itself
diffAdats(ex_data_small, ex_data_small)

# remove random column
rm <- withr::with_seed(123, sample(1:ncol(ex_data_small), 1))
diffAdats(ex_data_small, ex_data_small[, -rm])

# randomly shuffle Subarray
diffAdats(ex_data_small, dplyr::mutate(ex_data_small, Subarray = sample(Subarray)))

# modify 2 RFUs randomly
new <- ex_data_small
new[5L, c(rm, rm + 1L)] <- 999
diffAdats(ex_data_small, new)
}
\author{
Stu Field
}
